unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, AppEvnts, ExtCtrls;

type
  TForm1 = class(TForm)
    ApplicationEvents1: TApplicationEvents;
    ListBox1: TListBox;
    Panel1: TPanel;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    RadioButton3: TRadioButton;
    Button1: TButton;
    Button2: TButton;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    procedure FormResize(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure ApplicationEvents1Message(var Msg: tagMSG; var Handled: Boolean);
  private
    { Private declarations }
    przyciskiOdleglosc,szerokoscKolumny :Integer;
  public
    { Public declarations }
  protected
    procedure WndProc(var Message: TMessage); override;
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.ApplicationEvents1Message(var Msg: tagMSG;
  var Handled: Boolean);
begin
if RadioButton1.Checked then
  begin
  if CheckBox1.Checked and ((Msg.message=WM_MOUSEMOVE) or (Msg.message=WM_NCMOUSEMOVE)) then Exit;
  ListBox1.Items.Add(IntToStr(Msg.message)+'  '+IntToStr(Msg.wParam)+'  '+IntToStr(Msg.lParam));
  end;

if RadioButton2.Checked then
case Msg.message of
  //Odmalowywanie okna
  WM_PAINT: ListBox1.Items.Add('WM_PAINT');

  //Myszka
  WM_LBUTTONDOWN: ListBox1.Items.Add('WM_LBUTTONDOWN');
  WM_LBUTTONUP: ListBox1.Items.Add('WM_LBUTTONUP');
  WM_LBUTTONDBLCLK: ListBox1.Items.Add('WM_LBUTTONDBLCLK');
  WM_RBUTTONDOWN: ListBox1.Items.Add('WM_RBUTTONDOWN');
  WM_RBUTTONUP: ListBox1.Items.Add('WM_RBUTTONUP');
  WM_RBUTTONDBLCLK: ListBox1.Items.Add('WM_RBUTTONDBLCLK');
  WM_MBUTTONDOWN: ListBox1.Items.Add('WM_MBUTTONDOWN');
  WM_MBUTTONUP: ListBox1.Items.Add('WM_MBUTTONUP');
  WM_MBUTTONDBLCLK: ListBox1.Items.Add('WM_MBUTTONDBLCLK');

  //Klawiatura
  WM_KEYDOWN: ListBox1.Items.Add('WM_KEYDOWN');
  WM_KEYUP: ListBox1.Items.Add('WM_KEYUP');
  WM_CHAR: ListBox1.Items.Add('WM_CHAR');
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
ListBox1.Clear;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
Close;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
przyciskiOdleglosc:=Panel1.Width-Button1.Left;
szerokoscKolumny:=ListBox1.Width div ListBox1.Columns;
end;

procedure TForm1.FormResize(Sender: TObject);
begin
Button1.Left:=Panel1.Width-przyciskiOdleglosc;
Button2.Left:=Panel1.Width-przyciskiOdleglosc;

ListBox1.Columns:=ListBox1.Width div szerokoscKolumny;
end;

procedure TForm1.WndProc(var Message: TMessage);
begin
  inherited WndProc(Message);
  if (ListBox1<>nil) and (RadioButton3<>nil) and (CheckBox2<>nil) then
    begin
    if CheckBox2.Checked and ((Message.Msg=WM_SETCURSOR) or (Message.Msg=WM_NCHITTEST) or (Message.Msg=WM_NCMOUSEMOVE)) then Exit;
    if (Message.Msg<>308) and (ListBox1.Tag=0) then ListBox1.Items.Add(IntToStr(Message.Msg)+'  '+IntToStr(Message.wParam)+'  '+IntToStr(Message.lParam));
    end;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
ListBox1.Tag:=1;
end;

end.
